**********************************************************************************
*
* 'descriptive_stats.do'
*
* Generate descriptive statistics, all sample and dividing between developed/emerging
*
* Created       on June 19th  2020
* Last modified on June 22th  2020
*
**********************************************************************************


**********************************************************************************
* FOR LOG
cap log close                       
clear                             

log using "./log/descriptive_stats.log.do", replace text

* FOR LOG
display "$S_TIME  $S_DATE"
**********************************************************************************

**********************************************************************************
set more off
cap prog drop _all
**********************************************************************************

use "./output/LRbetas_daily_trade.dta", clear

* Treat "No Country" and "No Agreement" as the same thing:
replace EIA = 0 if EIA < 0

gen CUMECU = 0
replace CUMECU = 1 if EIA == 4 | EIA == 5 | EIA == 6
gen FTA = 0
replace FTA = 1 if EIA == 3 
gen TWPTA = 0
replace TWPTA = 1 if EIA == 2
gen OWPTA = 0 
replace OWPTA = 1 if EIA == 1
gen PTA = 0
replace PTA = 1 if EIA == 2 | EIA == 1

* Identifying missing observations
replace CUMECU = . if EIA == .
replace CUMECU = . if EIA == -999
replace FTA = . if EIA == .
replace FTA = . if EIA == -999
replace TWPTA = . if EIA == .
replace TWPTA = . if EIA == -999
replace OWPTA = . if EIA == .
replace PTA = . if EIA == .
replace PTA = . if EIA == -999

* Identifying emerging countries
cap drop emerging
gen emerging = 0
replace emerging = 1 if ///
	base == "BRL" | base == "CLP" | base == "CNY" | base == "COP" | base == "CZK" | base == "EGP" | base == "GRD" | ///
	base == "HUF" | base == "INR" | base == "IDR" | base == "KRW" | base == "MYR" | base == "MXN" | base == "PEN" | ///
	base == "PHP" | base == "PLN" | base == "QAR" | base == "RUB" | base == "ZAR" | base == "THB" | base == "TWD" | ///
	base == "TRY" | base == "AED" | base == "SAR" | base == "LKR" 
	
*Adding GDP
cap drop _merge
sort ISOPAIR year
merge 1:1 ISOPAIR year using "../task_data/output/gravity.dta"
drop if _merge == 2
drop _merge
	
cap drop trade_share	
gen trade_share = (  trade_gross / gdp_o )

cap egen id = group(ISOPAIR)
xtset id year
gen trade_g = import / 1000000000
gen d5_trade = trade_g - l5.trade_g
gen d10_trade = trade_g - l10.trade_g
	
cap rename d1_prc delta_close 

replace fx_vol = fx_vol*sqrt(252) /* Annualizing volatility */

set more off
eststo clear
estpost summarize beta R2_y fx_vol var_adj trade_g d5_trade d10_trade trade_share ///
					CUMECU FTA TWPTA OWPTA, detail
esttab using "./output/tables/table1.tex", ///
cells("count mean(fmt(3)) p50(fmt(3)) sd(fmt(3))") noobs ///
label varlabels(beta "Base Loadings, $ \beta$" ///
				R2_y "Share of Systematic Risk, $ R^2$" ///
				fx_vol "Volatility, $ \sigma$" ///
				var_adj "Unshared Risk, $ \rho$" ///
				trade_g "Imports (billions of USD)" ///
				d5_trade "Imports, five-year difference (billions of USD)" ///
				d10_trade "Imports ten-year difference (billions of USD)" ///
				trade_share "Imports, as a share of GDP") ///
collabels("Observations" "Mean" "Median" "Std. Dev.") nonumber replace

set more off
eststo clear
estpost summarize beta R2_y fx_vol var_adj trade_g d5_trade d10_trade trade_share ///
					CUMECU FTA TWPTA OWPTA if emerging == 0, detail
esttab using "./output/tables/tableA1_dev.tex", ///
cells("count mean(fmt(3)) p50(fmt(3)) sd(fmt(3))")  noobs ///
label varlabels(beta "Base Loadings, $ \beta$" ///
				R2_y "Share of Systematic Risk, $ R^2$" ///
				fx_vol "Volatility, $ \sigma$" ///
				var_adj "Unshared Risk, $ \rho$" ///
				trade_g "Imports (billions of USD)" ///
				d5_trade "Imports, five-year difference (billions of USD)" ///
				d10_trade "Imports ten-year difference (billions of USD)" ///
				trade_share "Imports, as a share of GDP") ///
collabels("Observations" "Mean" "Median" "Std. Dev.") nonumber replace

set more off
eststo clear
estpost summarize beta R2_y fx_vol var_adj trade_g d5_trade d10_trade trade_share ///
					CUMECU FTA TWPTA OWPTA if emerging == 1, detail
esttab using "./output/tables/tableA1_eme.tex", ///
cells("count mean(fmt(3)) p50(fmt(3)) sd(fmt(3))") noobs ///
label varlabels(beta "Base Loadings, $ \beta$" ///
				R2_y "Share of Systematic Risk, $ R^2$" ///
				fx_vol "Volatility, $ \sigma$" ///
				var_adj "Unshared Risk, $ \rho$" ///
				trade_g "Imports (billions of USD)" ///
				d5_trade "Imports, five-year difference (billions of USD)" ///
				d10_trade "Imports ten-year difference (billions of USD)" ///
				trade_share "Imports, as a share of GDP") ///
collabels("Observations" "Mean" "Median" "Std. Dev.") nonumber replace


**********************************************************************************
* FOR LOG
display "$S_TIME  $S_DATE"

log close
**********************************************************************************



